<?php

namespace App\Http\Controllers;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;

class AdminController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth:api');
    }

    /**
     * @OA\Post(
     *     path="/api/admin/getlist",
     *     operationId="admingetList",
     *     tags={"Protected Routes"},
     *     summary="Get List of Admins",
     *     description="This route requires authentication. Retrieves a list of Admins with details on added, updated, and deleted items.",
     *     security={{"bearerAuth": {}}},
     *     @OA\RequestBody(
     *         required=true,
     *         description="User credentials",
     *         @OA\JsonContent(
     *             @OA\Property(property="timestamp", type="string", format="timestamp", example=1828384884)
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful response",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="success", type="boolean", example=true),
     *             @OA\Property(property="added", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="id", type="integer", example=1),
     *                     @OA\Property(property="first_name", type="string"),
     *                     @OA\Property(property="last_name", type="string"),
     *                     @OA\Property(property="employee_id", type="string"),
     *                     @OA\Property(property="designation", type="string"),
     *                     @OA\Property(property="phone_number", type="string"),
     *                     @OA\Property(property="email", type="string"),
     *                     @OA\Property(property="address", type="string"),
     *                     @OA\Property(property="city", type="string"),
     *                     @OA\Property(property="state", type="string"),
     *                     @OA\Property(property="zip_code", type="string"),
     *                     @OA\Property(property="vendor", type="string"),
     *                     @OA\Property(property="builder_contractor", type="string"),
     *                     @OA\Property(property="vendor_category_id", type="string"),
     *                     @OA\Property(property="company_name", type="string"),
     *                     @OA\Property(property="service_area", type="string"),
     *                     @OA\Property(property="website", type="string"),
     *                     @OA\Property(property="slug", type="string"),
     *                     @OA\Property(property="company_logo", type="string"),
     *                     @OA\Property(property="user_type", type="string"),
     *                     @OA\Property(property="public_profile", type="string"),
     *                     @OA\Property(property="member", type="string"),
     *                     @OA\Property(property="partner", type="string"),
     *                     @OA\Property(property="partner_type", type="string"),
     *                     @OA\Property(property="banner_rotation", type="string"),
     *                     @OA\Property(property="banner_file", type="string"),
     *                     @OA\Property(property="banner_link", type="string"),
     *                     @OA\Property(property="rotation_logo_file", type="string"),
     *                     @OA\Property(property="rotation_logo_link", type="string"),
     *                     @OA\Property(property="headline_bg_image", type="string"),
     *                     @OA\Property(property="headline_description", type="string"),
     *                     @OA\Property(property="remember_token", type="string"),
     *                     @OA\Property(property="forgot_token", type="string"),
     *                     @OA\Property(property="vendor_toke", type="string")
     *                 ),
     *             ),
     *             @OA\Property(property="updated", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="id", type="integer", example=1),
     *                     @OA\Property(property="first_name", type="string"),
     *                     @OA\Property(property="last_name", type="string"),
     *                     @OA\Property(property="employee_id", type="string"),
     *                     @OA\Property(property="designation", type="string"),
     *                     @OA\Property(property="phone_number", type="string"),
     *                     @OA\Property(property="email", type="string"),
     *                     @OA\Property(property="address", type="string"),
     *                     @OA\Property(property="city", type="string"),
     *                     @OA\Property(property="state", type="string"),
     *                     @OA\Property(property="zip_code", type="string"),
     *                     @OA\Property(property="vendor", type="string"),
     *                     @OA\Property(property="builder_contractor", type="string"),
     *                     @OA\Property(property="vendor_category_id", type="string"),
     *                     @OA\Property(property="company_name", type="string"),
     *                     @OA\Property(property="service_area", type="string"),
     *                     @OA\Property(property="website", type="string"),
     *                     @OA\Property(property="slug", type="string"),
     *                     @OA\Property(property="company_logo", type="string"),
     *                     @OA\Property(property="user_type", type="string"),
     *                     @OA\Property(property="public_profile", type="string"),
     *                     @OA\Property(property="member", type="string"),
     *                     @OA\Property(property="partner", type="string"),
     *                     @OA\Property(property="partner_type", type="string"),
     *                     @OA\Property(property="banner_rotation", type="string"),
     *                     @OA\Property(property="banner_file", type="string"),
     *                     @OA\Property(property="banner_link", type="string"),
     *                     @OA\Property(property="rotation_logo_file", type="string"),
     *                     @OA\Property(property="rotation_logo_link", type="string"),
     *                     @OA\Property(property="headline_bg_image", type="string"),
     *                     @OA\Property(property="headline_description", type="string"),
     *                     @OA\Property(property="remember_token", type="string"),
     *                     @OA\Property(property="forgot_token", type="string"),
     *                     @OA\Property(property="vendor_toke", type="string")
     *                 ),
     *             ),
     *             @OA\Property(property="deleted", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="id", type="integer", example=1),
     *                     @OA\Property(property="first_name", type="string"),
     *                     @OA\Property(property="last_name", type="string"),
     *                     @OA\Property(property="employee_id", type="string"),
     *                     @OA\Property(property="designation", type="string"),
     *                     @OA\Property(property="phone_number", type="string"),
     *                     @OA\Property(property="email", type="string"),
     *                     @OA\Property(property="address", type="string"),
     *                     @OA\Property(property="city", type="string"),
     *                     @OA\Property(property="state", type="string"),
     *                     @OA\Property(property="zip_code", type="string"),
     *                     @OA\Property(property="vendor", type="string"),
     *                     @OA\Property(property="builder_contractor", type="string"),
     *                     @OA\Property(property="vendor_category_id", type="string"),
     *                     @OA\Property(property="company_name", type="string"),
     *                     @OA\Property(property="service_area", type="string"),
     *                     @OA\Property(property="website", type="string"),
     *                     @OA\Property(property="slug", type="string"),
     *                     @OA\Property(property="company_logo", type="string"),
     *                     @OA\Property(property="user_type", type="string"),
     *                     @OA\Property(property="public_profile", type="string"),
     *                     @OA\Property(property="member", type="string"),
     *                     @OA\Property(property="partner", type="string"),
     *                     @OA\Property(property="partner_type", type="string"),
     *                     @OA\Property(property="banner_rotation", type="string"),
     *                     @OA\Property(property="banner_file", type="string"),
     *                     @OA\Property(property="banner_link", type="string"),
     *                     @OA\Property(property="rotation_logo_file", type="string"),
     *                     @OA\Property(property="rotation_logo_link", type="string"),
     *                     @OA\Property(property="headline_bg_image", type="string"),
     *                     @OA\Property(property="headline_description", type="string"),
     *                     @OA\Property(property="remember_token", type="string"),
     *                     @OA\Property(property="forgot_token", type="string"),
     *                     @OA\Property(property="vendor_toke", type="string")
     *                 ),
     *             ),
     *         ),
     *     ),
     * )
     */
    public function getList(Request $request){
        $currentTimeStamp = $request->timestamp ? Carbon::createFromTimestamp($request->timestamp)->format('Y-m-d') : null;
        $added = [];
        $updated = [];
        $deleted = [];
        if($currentTimeStamp){
            $added = User::where('user_type',1)->whereNull('deleted_at')->whereDate('created_at','>=',$currentTimeStamp)->get(['first_name','last_name','employee_id','designation','phone_number','email','address','city','state','zip_code','vendor','builder_contractor','vendor_category_id','company_name','service_area','website','slug','company_logo','user_type','public_profile','member','partner','partner_type','banner_rotation','banner_file','banner_link','rotation_logo_file','rotation_logo_link','headline_bg_image','headline_description','remember_token','forgot_token','vendor_toke']);
            $addedIDs = $added->pluck('id')->toArray();
            $updated = User::where('user_type',1)->whereNull('deleted_at')->whereNotIn('id',$addedIDs)->whereDate('updated_at','>=',$currentTimeStamp)->get(['first_name','last_name','employee_id','designation','phone_number','email','address','city','state','zip_code','vendor','builder_contractor','vendor_category_id','company_name','service_area','website','slug','company_logo','user_type','public_profile','member','partner','partner_type','banner_rotation','banner_file','banner_link','rotation_logo_file','rotation_logo_link','headline_bg_image','headline_description','remember_token','forgot_token','vendor_toke']);
            $deleted = User::where('user_type',1)->whereNotNull('deleted_at')->whereDate('updated_at','>=',$currentTimeStamp)->get(['first_name','last_name','employee_id','designation','phone_number','email','address','city','state','zip_code','vendor','builder_contractor','vendor_category_id','company_name','service_area','website','slug','company_logo','user_type','public_profile','member','partner','partner_type','banner_rotation','banner_file','banner_link','rotation_logo_file','rotation_logo_link','headline_bg_image','headline_description','remember_token','forgot_token','vendor_toke']);
        }else{
            $added = User::where('user_type',1)->whereNull('deleted_at')->get(['first_name','last_name','employee_id','designation','phone_number','email','address','city','state','zip_code','vendor','builder_contractor','vendor_category_id','company_name','service_area','website','slug','company_logo','user_type','public_profile','member','partner','partner_type','banner_rotation','banner_file','banner_link','rotation_logo_file','rotation_logo_link','headline_bg_image','headline_description','remember_token','forgot_token','vendor_toke']);
            $deleted = User::where('user_type',1)->whereNotNull('deleted_at')->get(['first_name','last_name','employee_id','designation','phone_number','email','address','city','state','zip_code','vendor','builder_contractor','vendor_category_id','company_name','service_area','website','slug','company_logo','user_type','public_profile','member','partner','partner_type','banner_rotation','banner_file','banner_link','rotation_logo_file','rotation_logo_link','headline_bg_image','headline_description','remember_token','forgot_token','vendor_toke']);
        }
        return ['success'=>true,"added"=>$added, "updated"=>$updated, "deleted"=>$deleted];
    }
}
