<?php

namespace App\Http\Controllers;

use App\Models\Technician;
use App\Models\Techniciantracklocation;
use App\Models\User;
use App\Repositories\UserRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Tymon\JWTAuth\Exceptions\JWTException;
use Tymon\JWTAuth\Facades\JWTAuth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use OpenApi\Annotations as OA;
class AuthController extends Controller
{
    protected $userRepository;
    public function __construct(UserRepository $userRepository)
    {
        $this->middleware('auth:api', ['except' => ['login','userLogin']]);//login, register methods won't go through the api guard
        $this->userRepository = $userRepository;
    }
    /**
     * @OA\Post(
     *     path="/api/login",
     *     operationId="login",
     *     tags={"Authentication"},
     *     summary="User login",
     *     description="Authenticate a user and get an access token.",
     *     @OA\RequestBody(
     *         required=true,
     *         description="User credentials",
     *         @OA\JsonContent(
     *             required={"email", "password"},
     *             @OA\Property(property="email", type="string", format="email", example="examplr@propelts.com"),
     *             @OA\Property(property="password", type="string", format="password", example="yourpassword")
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful or Unsuccessful login",
     *         @OA\JsonContent(
     *               type="object",
     *               @OA\Property(property="success", type="boolean", example=true),
     *               @OA\Property(
     *                   property="user_details",
     *                   type="object",
     *                   @OA\Property(property="user_id", type="integer", example=1),
     *                   @OA\Property(property="subscriber_id", type="integer", example=0),
     *                   @OA\Property(property="client_id", type="integer", example=0),
     *                   @OA\Property(property="phone_no", type="string", example=null),
     *                   @OA\Property(property="player_id", type="string", example=null),
     *                   @OA\Property(property="username", type="string", example="rodney@propelts.com"),
     *                   @OA\Property(property="first_name", type="string", example="Admin"),
     *                   @OA\Property(property="last_name", type="string", example="PHLEBIO"),
     *                   @OA\Property(property="contact_no", type="string", example="5555555555"),
     *                   @OA\Property(property="email", type="string", format="email", example="rodney@propelts.com"),
     *                   @OA\Property(property="profile_image", type="string", example=null),
     *                   @OA\Property(property="profile_summary", type="string", example=null),
     *                   @OA\Property(property="is_admin", type="integer", example=1),
     *                   @OA\Property(property="user_type", type="integer", example=1),
     *                   @OA\Property(property="created_by", type="integer", example=1),
     *                   @OA\Property(property="column_visibility", type="integer", example=1),
     *                   @OA\Property(property="office_phone", type="string"),
     *                   @OA\Property(property="extension", type="string"),
     *                   @OA\Property(property="employee_no", type="string"),
     *                   @OA\Property(property="json_visiblility", type="integer"),
     *                   @OA\Property(property="manage_admins", type="integer"),
     *                   @OA\Property(property="manage_technicians", type="integer"),
     *                   @OA\Property(property="delete_clients", type="integer"),
     *                   @OA\Property(property="access_AP_mileage_report", type="integer"),
     *                   @OA\Property(property="group_id", type="string"),
     *               ),
     *               @OA\Property(
     *                   property="authentication",
     *                   type="object",
     *                   @OA\Property(property="access_token", type="string", example="eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9..."),
     *                   @OA\Property(property="token_type", type="string", example="bearer"),
     *                   @OA\Property(property="expires_in", type="integer", example=3600),
     *               ),
     *               @OA\Property(property="message", type="string", example="Successfully Log in"),
     *          ),
     *      ),
     * )
     */
    public function login(Request $request){
        $credentials = $request->only('email', 'password');
        $token = null;
        try {
            if (!$token = JWTAuth::attempt($credentials)) {
                return response()->json(['success'=>false,'user_details'=>null,'authentication'=>null,'message' => 'Invalid Credentials']);
            }
        } catch (JWTException $e) {
            return response()->json(['success'=>false,'user_details'=>null,'authentication'=>null,'message' => 'Could Not Create Token']);
        }

        $imagingTech = false;
        $userDetails = User::where('email',$request->email)->whereNull('deleted_at')->first(["user_id",'subscriber_id',
            'client_id','phone_no','player_id',"username","first_name","last_name","name","contact_no","email",
            "profile_image","profile_summary","is_admin","user_type","created_by",
            "column_visibility","json_visiblility","manage_admins",
            "manage_technicians","delete_clients"]);

        if($userDetails->user_type==5)
        {
            $technician = Technician::where('tech_userid',$userDetails->user_id)->first();
            if($technician!=null)
            {
                $userDetails->first_name = $technician->tech_first_name;
                $userDetails->last_name = $technician->tech_last_name;
                $userDetails->name = $technician->tech_name;

                if (array_key_exists('technician_type', $technician->getAttributes()) && $technician->technician_type == 2) {
                    $imagingTech = true;
                }
            }
        }

        $shiftStatus = null;
        if ($userDetails) {
            $shiftStatus = Techniciantracklocation::where('tech_id', $userDetails->user_id)
                        ->orderBy('id', 'DESC')
                        ->value('shift_status');
        }

        if(!$userDetails){
            return response()->json(['success'=>false,'user_details'=>null,'authentication'=>null,'message' => 'Account has been Deleted! Please contact to the admin']);
        }
        if($userDetails->first_name==null)
        {
            $userDetails->first_name = "Technician";
        }
        if($userDetails->last_name==null)
        {
            $userDetails->first_name = "User";
        }
        return ['success'=>true,'user_details'=>$userDetails,'shift_status'=>$shiftStatus,'authentication'=>$this->respondWithToken($token),'message' =>'Successfully Logged in'];

    }
    


    /**
     * @OA\Get(
     *     path="/api/logout",
     *     operationId="protectedRoute",
     *     tags={"Protected Routes"},
     *     summary="Protected Route",
     *     description="This route requires authentication.",
     *     security={{"bearerAuth": {}}},
     *     @OA\Response(
     *         response=200,
     *         description="Successful response",
     *         @OA\JsonContent(
     *               type="object",
     *               @OA\Property(property="success", type="boolean", example=true),
     *               @OA\Property(property="message", type="string", example="Successfully logged out"),
     *         ),
     *     ),
     * )
     */
    public function logout()
    {
        auth()->logout();
        return response()->json(['success'=>true,'message' => 'Successfully logged out']);
    }

    public function refresh()
    {
        return ['success'=>true,'authentication'=>$this->respondWithToken(Auth::refresh()),'message' => 'Token Refresh'];
    }
    protected function credentials(Request $request)
    {
       return ['email' => $request->email, 'password' => $request->password, 'status' => 1, 'delete_status' => 0];
    }
    protected function respondWithToken($token)
    {
        return [
            'access_token' => $token,
            'token_type' => 'bearer'
        ];
    }
    public function techEnv()
    {
        $user_id = JWTAuth::user()->user_id;
        $data = [
            "date_time"=>true, // can select past future dates
            "date_range"=>true,
            "auto_en_route"=>false,
            "navigation"=>true,
            "show_only_today_stops"=>true,
            "stop_display_restriction"=>0,
            "first_stop_visible"=>true,
            "auto_stop_proximity"=>true,
            "can_reject_stop"=>true,
            "can_transfer_stop"=>true,
            "group_stop"=>false,
            "call_client"=>true,
            "chat_client"=>true,
            "patient_signature"=>true,
            "print_requisition"=>true,
            "missed_draw"=>true,
            "add_edit_insurance"=>true,
            "add_edit_test"=>true,
            "add_edit_specimen"=>true,
            "specimen_barcode"=>true,
            "edit_provider"=>true,
            "edit_dx"=>true,
            "request_return_visit"=>true,
            "preview_image"=>true,
            "add_notes"=>true,
            "add_file"=>true,
            "facility_collection"=>true,
            "facility_add_edit_insurance"=>true,
            "facility_add_edit_specimen"=>true,
            "facility_specimen_barcode"=>true,
            "facility_edit_provider"=>true,
            "facility_edit_dx"=>true,
            "facility_request_return_visit"=>true,
            "facility_preview_image"=>true,
            "facility_add_notes"=>true,
            "facility_add_file"=>true,
            "deliver_to_lab"=>true,
            "transfer_technician"=>true,
            "skip_drop_off"=>true,
            "technician_messenger"=>true,
            "show_collection_by_date_range"=>true,
            "show_fasting_icon"=>true,
            "schedule_timer"=>false,
            'end_shift_notes_required'=>true,
            'hide_deliver_to_lab'=>true,
            'camera_icon_rejection'=>true,
            'camera_icon_order_details'=>true,
            'gallery_access_in_app'=>true

        ];

        return ['success'=>true,'data'=>$data];

    }

    public function userLogin(Request $request)
    {
        return $this->userRepository->userLogin($request);
    }
    public function getUser(Request $request)
    {
        return $this->userRepository->getUser();
    }

    public function checkLogin(Request $request)
    {
        return $this->userRepository->checkLogin($request);
    }
    // public function refresh()
    // {
    //     return $this->respondWithToken(auth()->refresh());
    // }
    // protected function respondWithToken($token)
    // {
    //     return response()->json([
    //         'access_token' => $token,
    //         'token_type' => 'bearer',
    //         'expires_in' => auth()->factory()->getTTL() * 3600
    //     ]);
    // }
}
