<?php

namespace App\Http\Controllers;

use App\Models\Provider;
use Carbon\Carbon;
use Illuminate\Http\Request;

class ProviderController extends Controller
{
    /**
     * @OA\Post(
     *     path="/api/provider/getlist",
     *     operationId="providerList",
     *     tags={"Protected Routes"},
     *     summary="Get List of provider",
     *     description="This route requires authentication. Retrieves a list of provider with details on added, updated, and deleted items.",
     *     security={{"bearerAuth": {}}},
     *     @OA\RequestBody(
     *         required=true,
     *         description="User credentials",
     *         @OA\JsonContent(
     *             @OA\Property(property="timestamp", type="string", format="timestamp", example=1828384884)
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful response",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="success", type="boolean", example=true),
     *             @OA\Property(property="added", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                       @OA\Property(property="provider_name", type="string"),
     *                       @OA\Property(property="provider_first_name", type="string"),
     *                       @OA\Property(property="provider_middle_name", type="string"),
     *                       @OA\Property(property="provider_last_name", type="string"),
     *                       @OA\Property(property="provider_title", type="string"),
     *                       @OA\Property(property="provider_lic_number", type="string"),
     *                       @OA\Property(property="provider_npi", type="string"),
     *                       @OA\Property(property="provider_email", type="string"),
     *                       @OA\Property(property="provider_phone", type="string"),
     *                       @OA\Property(property="provider_fax", type="string"),
     *                       @OA\Property(property="provider_website", type="string"),
     *                       @OA\Property(property="provider_street", type="string"),
     *                       @OA\Property(property="provider_city", type="string"),
     *                       @OA\Property(property="provider_state", type="string"),
     *                       @OA\Property(property="provider_zip", type="string"),
     *                       @OA\Property(property="provider_lab", type="string"),
     *                       @OA\Property(property="provider_lab_acct", type="string"),
     *                       @OA\Property(property="provider_notes", type="string"),
     *                       @OA\Property(property="status", type="string"),
     *                       @OA\Property(property="subscriber_id", type="string"),
     *                       @OA\Property(property="delete_by", type="string"),
     *                       @OA\Property(property="delete_status", type="string"),
     *                       @OA\Property(property="provider_signature", type="string"),
     *                       @OA\Property(property="sms_notification", type="string"),
     *                       @OA\Property(property="email_notification", type="string"),
     *                       @OA\Property(property="sms_notification_status", type="string"),
     *                       @OA\Property(property="email_notification_status", type="string"),
     *
     *                 ),
     *             ),
     *             @OA\Property(property="updated", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                       @OA\Property(property="provider_name", type="string"),
     *                       @OA\Property(property="provider_first_name", type="string"),
     *                       @OA\Property(property="provider_middle_name", type="string"),
     *                       @OA\Property(property="provider_last_name", type="string"),
     *                       @OA\Property(property="provider_title", type="string"),
     *                       @OA\Property(property="provider_lic_number", type="string"),
     *                       @OA\Property(property="provider_npi", type="string"),
     *                       @OA\Property(property="provider_email", type="string"),
     *                       @OA\Property(property="provider_phone", type="string"),
     *                       @OA\Property(property="provider_fax", type="string"),
     *                       @OA\Property(property="provider_website", type="string"),
     *                       @OA\Property(property="provider_street", type="string"),
     *                       @OA\Property(property="provider_city", type="string"),
     *                       @OA\Property(property="provider_state", type="string"),
     *                       @OA\Property(property="provider_zip", type="string"),
     *                       @OA\Property(property="provider_lab", type="string"),
     *                       @OA\Property(property="provider_lab_acct", type="string"),
     *                       @OA\Property(property="provider_notes", type="string"),
     *                       @OA\Property(property="status", type="string"),
     *                       @OA\Property(property="subscriber_id", type="string"),
     *                       @OA\Property(property="delete_by", type="string"),
     *                       @OA\Property(property="delete_status", type="string"),
     *                       @OA\Property(property="provider_signature", type="string"),
     *                       @OA\Property(property="sms_notification", type="string"),
     *                       @OA\Property(property="email_notification", type="string"),
     *                       @OA\Property(property="sms_notification_status", type="string"),
     *                       @OA\Property(property="email_notification_status", type="string"),
     *
     *                 ),
     *             ),
     *             @OA\Property(property="deleted", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                       @OA\Property(property="provider_name", type="string"),
     *                       @OA\Property(property="provider_first_name", type="string"),
     *                       @OA\Property(property="provider_middle_name", type="string"),
     *                       @OA\Property(property="provider_last_name", type="string"),
     *                       @OA\Property(property="provider_title", type="string"),
     *                       @OA\Property(property="provider_lic_number", type="string"),
     *                       @OA\Property(property="provider_npi", type="string"),
     *                       @OA\Property(property="provider_email", type="string"),
     *                       @OA\Property(property="provider_phone", type="string"),
     *                       @OA\Property(property="provider_fax", type="string"),
     *                       @OA\Property(property="provider_website", type="string"),
     *                       @OA\Property(property="provider_street", type="string"),
     *                       @OA\Property(property="provider_city", type="string"),
     *                       @OA\Property(property="provider_state", type="string"),
     *                       @OA\Property(property="provider_zip", type="string"),
     *                       @OA\Property(property="provider_lab", type="string"),
     *                       @OA\Property(property="provider_lab_acct", type="string"),
     *                       @OA\Property(property="provider_notes", type="string"),
     *                       @OA\Property(property="status", type="string"),
     *                       @OA\Property(property="subscriber_id", type="string"),
     *                       @OA\Property(property="delete_by", type="string"),
     *                       @OA\Property(property="delete_status", type="string"),
     *                       @OA\Property(property="provider_signature", type="string"),
     *                       @OA\Property(property="sms_notification", type="string"),
     *                       @OA\Property(property="email_notification", type="string"),
     *                       @OA\Property(property="sms_notification_status", type="string"),
     *                       @OA\Property(property="email_notification_status", type="string"),
     *
     *                 ),
     *             ),
     *         ),
     *     ),
     * )
     */
    public function getList(Request $request){
        $currentTimeStamp = $request->timestamp ? Carbon::createFromTimestamp($request->timestamp)->format('Y-m-d') : null;
        $added = [];
        $updated = [];
        $deleted = [];
        if($currentTimeStamp){
            // whereNull('deleted_at')
            // whereNotNull('deleted_at')
            $added = Provider::whereNull('deleted_at')->whereDate('created_at','>=',$currentTimeStamp)->get(['provider_id','provider_name',
            'provider_first_name',
            'provider_middle_name',
            'provider_last_name',
            'provider_title',
            'provider_lic_number',
            'provider_npi',
            'provider_email',
            'provider_phone',
            'provider_fax',
            'provider_website',
            'provider_street',
            'provider_city',
            'provider_state',
            'provider_zip',
            'provider_lab',
            'provider_lab_acct',
            'provider_notes',
            'status',
            'subscriber_id',
            'delete_by',
            'delete_status',
            'provider_signature',
            'sms_notification',
            'email_notification',
            'sms_notification_status',
            'email_notification_status']);
            $addedIDs = $added->pluck('provider_id')->toArray();
            $updated = Provider::whereNotIn('provider_id',$addedIDs)->whereNull('deleted_at')->whereDate('updated_at','>=',$currentTimeStamp)->get(['provider_id','provider_name',
            'provider_first_name',
            'provider_middle_name',
            'provider_last_name',
            'provider_title',
            'provider_lic_number',
            'provider_npi',
            'provider_email',
            'provider_phone',
            'provider_fax',
            'provider_website',
            'provider_street',
            'provider_city',
            'provider_state',
            'provider_zip',
            'provider_lab',
            'provider_lab_acct',
            'provider_notes',
            'status',
            'subscriber_id',
            'delete_by',
            'delete_status',
            'provider_signature',
            'sms_notification',
            'email_notification',
            'sms_notification_status',
            'email_notification_status']);
            $deleted = Provider::whereNotNull('deleted_at')->whereDate('updated_at','>=',$currentTimeStamp)->get(['provider_id','provider_name',
            'provider_first_name',
            'provider_middle_name',
            'provider_last_name',
            'provider_title',
            'provider_lic_number',
            'provider_npi',
            'provider_email',
            'provider_phone',
            'provider_fax',
            'provider_website',
            'provider_street',
            'provider_city',
            'provider_state',
            'provider_zip',
            'provider_lab',
            'provider_lab_acct',
            'provider_notes',
            'status',
            'subscriber_id',
            'delete_by',
            'delete_status',
            'provider_signature',
            'sms_notification',
            'email_notification',
            'sms_notification_status',
            'email_notification_status']);
        }else{
            $added = Provider::whereNull('deleted_at')->get(['provider_id','provider_name',
            'provider_first_name',
            'provider_middle_name',
            'provider_last_name',
            'provider_title',
            'provider_lic_number',
            'provider_npi',
            'provider_email',
            'provider_phone',
            'provider_fax',
            'provider_website',
            'provider_street',
            'provider_city',
            'provider_state',
            'provider_zip',
            'provider_lab',
            'provider_lab_acct',
            'provider_notes',
            'status',
            'subscriber_id',
            'delete_by',
            'delete_status',
            'provider_signature',
            'sms_notification',
            'email_notification',
            'sms_notification_status',
            'email_notification_status']);
            $deleted = Provider::whereNotNull('deleted_at')->get(['provider_id','provider_name',
            'provider_first_name',
            'provider_middle_name',
            'provider_last_name',
            'provider_title',
            'provider_lic_number',
            'provider_npi',
            'provider_email',
            'provider_phone',
            'provider_fax',
            'provider_website',
            'provider_street',
            'provider_city',
            'provider_state',
            'provider_zip',
            'provider_lab',
            'provider_lab_acct',
            'provider_notes',
            'status',
            'subscriber_id',
            'delete_by',
            'delete_status',
            'provider_signature',
            'sms_notification',
            'email_notification',
            'sms_notification_status',
            'email_notification_status']);
        }
        return ['success'=>true,"added"=>$added, "updated"=>$updated, "deleted"=>$deleted];
    }
}
