<?php

namespace App\Http\Controllers;

use App\Models\Clientasset;
use Carbon\Carbon;
use Illuminate\Http\Request;

class ClientAssetController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:api');
    }
    /**
     * @OA\Post(
     *     path="/api/clientasset/getlist",
     *     operationId="ClientassetList",
     *     tags={"Protected Routes"},
     *     summary="Get List of Clientasset",
     *     description="This route requires authentication. Retrieves a list of Clientasset with details on added, updated, and deleted items.",
     *     security={{"bearerAuth": {}}},
     *     @OA\RequestBody(
     *         required=true,
     *         description="User credentials",
     *         @OA\JsonContent(
     *             @OA\Property(property="timestamp", type="string", format="timestamp", example=1828384884)
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful response",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="success", type="boolean", example=true),
     *             @OA\Property(property="added", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                       @OA\Property(property="client_id", type="integer", example=501),
     *                       @OA\Property(property="asset_id_barcode", type="string", example="12345678"),
     *                       @OA\Property(property="asset_name", type="string", example="Test Refrigerator"),
     *                       @OA\Property(property="asset_notes", type="string", example="2nd floor, room 5"),
     *                       @OA\Property(property="delete_by", type="integer", example=0),
     *                       @OA\Property(property="delete_status", type="integer", example=0),
     *                 ),
     *             ),
     *             @OA\Property(property="updated", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                       @OA\Property(property="client_id", type="integer", example=501),
     *                       @OA\Property(property="asset_id_barcode", type="string", example="12345678"),
     *                       @OA\Property(property="asset_name", type="string", example="Test Refrigerator"),
     *                       @OA\Property(property="asset_notes", type="string", example="2nd floor, room 5"),
     *                       @OA\Property(property="delete_by", type="integer", example=0),
     *                       @OA\Property(property="delete_status", type="integer", example=0),
     *                 ),
     *             ),
     *             @OA\Property(property="deleted", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                       @OA\Property(property="client_id", type="integer", example=501),
     *                       @OA\Property(property="asset_id_barcode", type="string", example="12345678"),
     *                       @OA\Property(property="asset_name", type="string", example="Test Refrigerator"),
     *                       @OA\Property(property="asset_notes", type="string", example="2nd floor, room 5"),
     *                       @OA\Property(property="delete_by", type="integer", example=0),
     *                       @OA\Property(property="delete_status", type="integer", example=0),
     *                 ),
     *             ),
     *         ),
     *     ),
     * )
     */
    public function getList(Request $request){
        $currentTimeStamp = $request->timestamp ? Carbon::createFromTimestamp($request->timestamp)->format('Y-m-d') : null;
        $added = [];
        $updated = [];
        $deleted = [];
        if($currentTimeStamp){
            $added = Clientasset::whereNull('deleted_at')->whereDate('created_at','>=',$currentTimeStamp)->get(["id",'client_id','asset_id_barcode','asset_name','asset_notes','delete_by','deleted_at']);
            $addedIDs = $added->pluck('id')->toArray();
            $updated = Clientasset::whereNotIn('id',$addedIDs)->whereNull('deleted_at')->whereDate('updated_at','>=',$currentTimeStamp)->get(["id",'client_id','asset_id_barcode','asset_name','asset_notes','delete_by','deleted_at']);
            $deleted = Clientasset::whereNotNull('deleted_at')->whereDate('updated_at','>=',$currentTimeStamp)->get(["id",'client_id','asset_id_barcode','asset_name','asset_notes','delete_by','deleted_at']);
        }else{
            $added = Clientasset::whereNull('deleted_at')->get(["id",'client_id','asset_id_barcode','asset_name','asset_notes','delete_by','deleted_at']);
            $deleted = Clientasset::whereNotNull('deleted_at')->get(["id",'client_id','asset_id_barcode','asset_name','asset_notes','delete_by','deleted_at']);
        }
        return ['success'=>true,"added"=>$added, "updated"=>$updated, "deleted"=>$deleted];
    }
}
