<?php

namespace App\Http\Controllers;

use App\Models\Client;
use Carbon\Carbon;
use Illuminate\Http\Request;

class ClientController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:api');
    }
    /**
     * @OA\Post(
     *     path="/api/client/getlist",
     *     operationId="ClientList",
     *     tags={"Protected Routes"},
     *     summary="Get List of Client",
     *     description="This route requires authentication. Retrieves a list of Client with details on added, updated, and deleted items.",
     *     security={{"bearerAuth": {}}},
     *     @OA\RequestBody(
     *         required=true,
     *         description="User credentials",
     *         @OA\JsonContent(
     *             @OA\Property(property="timestamp", type="string", format="timestamp", example=1828384884)
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful response",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="success", type="boolean", example=true),
     *             @OA\Property(property="added", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                       @OA\Property(property="client_name", type="string", example="ARCADIA CARE BLOOMINGTON[ACBLO]"),
     *                       @OA\Property(property="client_email", type="string", nullable=true),
     *                       @OA\Property(property="client_phone", type="string", example="1-309-827-6046"),
     *                       @OA\Property(property="client_fax", type="string", nullable=true),
     *                       @OA\Property(property="client_website", type="string", nullable=true),
     *                       @OA\Property(property="client_type", type="string", nullable=true),
     *                       @OA\Property(property="client_street", type="string", example="1509 N CALHOUN STREET"),
     *                       @OA\Property(property="client_city", type="string", example="BLOOMINGTON"),
     *                       @OA\Property(property="client_state", type="string", example="IL"),
     *                       @OA\Property(property="client_zip", type="string", example="61701"),
     *                       @OA\Property(property="client_lab", type="string", nullable=true),
     *                       @OA\Property(property="client_lab_acct", type="string", nullable=true),
     *                       @OA\Property(property="client_signed_agreement", type="string", nullable=true),
     *                       @OA\Property(property="client_preferred_lab", type="string", nullable=true),
     *                       @OA\Property(property="client_warning", type="string", nullable=true),
     *                       @OA\Property(property="client_notes", type="string", nullable=true),
     *                       @OA\Property(property="status", type="integer", example=1),
     *                       @OA\Property(property="subscriber_id", type="integer", example=9),
     *                       @OA\Property(property="delete_status", type="integer", example=0),
     *                       @OA\Property(property="delete_by", type="integer", nullable=true),
     *                       @OA\Property(property="service_day", type="string", nullable=true),
     *                       @OA\Property(property="latitude", type="string", example="40.493323"),
     *                       @OA\Property(property="longitude", type="string", example="-89.005142"),
     *                       @OA\Property(property="sms_notification", type="integer", example=0),
     *                       @OA\Property(property="email_notification", type="integer", example=0),
     *                       @OA\Property(property="sms_notification_status", type="string", nullable=true),
     *                       @OA\Property(property="email_notification_status", type="string", nullable=true),
     *                       @OA\Property(property="lab_account_no", type="string", nullable=true),
     *                       @OA\Property(property="client_street2", type="string", example=""),
     *                       @OA\Property(property="clientID", type="string", example="ACBLO"),
     *                       @OA\Property(property="master_client_ID", type="string", example="ACBLO"),
     *                       @OA\Property(property="master_client_name", type="string", example="ARCADIA CARE BLOOMINGTON"),
     *                       @OA\Property(property="provider_id", type="string", example="177,245,538,566,648,660,725,694,8,1002,28,26,2141,702,60,27,22,29,2174,2184,143,2199,39,1534,2197,160,54,243,1517,1756,2136,135"),
     *                       @OA\Property(property="ownership_group", type="string", example="ARCD"),
     *                 ),
     *             ),
     *             @OA\Property(property="updated", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                       @OA\Property(property="client_name", type="string", example="ARCADIA CARE BLOOMINGTON[ACBLO]"),
     *                       @OA\Property(property="client_email", type="string", nullable=true),
     *                       @OA\Property(property="client_phone", type="string", example="1-309-827-6046"),
     *                       @OA\Property(property="client_fax", type="string", nullable=true),
     *                       @OA\Property(property="client_website", type="string", nullable=true),
     *                       @OA\Property(property="client_type", type="string", nullable=true),
     *                       @OA\Property(property="client_street", type="string", example="1509 N CALHOUN STREET"),
     *                       @OA\Property(property="client_city", type="string", example="BLOOMINGTON"),
     *                       @OA\Property(property="client_state", type="string", example="IL"),
     *                       @OA\Property(property="client_zip", type="string", example="61701"),
     *                       @OA\Property(property="client_lab", type="string", nullable=true),
     *                       @OA\Property(property="client_lab_acct", type="string", nullable=true),
     *                       @OA\Property(property="client_signed_agreement", type="string", nullable=true),
     *                       @OA\Property(property="client_preferred_lab", type="string", nullable=true),
     *                       @OA\Property(property="client_warning", type="string", nullable=true),
     *                       @OA\Property(property="client_notes", type="string", nullable=true),
     *                       @OA\Property(property="status", type="integer", example=1),
     *                       @OA\Property(property="subscriber_id", type="integer", example=9),
     *                       @OA\Property(property="delete_status", type="integer", example=0),
     *                       @OA\Property(property="delete_by", type="integer", nullable=true),
     *                       @OA\Property(property="service_day", type="string", nullable=true),
     *                       @OA\Property(property="latitude", type="string", example="40.493323"),
     *                       @OA\Property(property="longitude", type="string", example="-89.005142"),
     *                       @OA\Property(property="sms_notification", type="integer", example=0),
     *                       @OA\Property(property="email_notification", type="integer", example=0),
     *                       @OA\Property(property="sms_notification_status", type="string", nullable=true),
     *                       @OA\Property(property="email_notification_status", type="string", nullable=true),
     *                       @OA\Property(property="lab_account_no", type="string", nullable=true),
     *                       @OA\Property(property="client_street2", type="string", example=""),
     *                       @OA\Property(property="clientID", type="string", example="ACBLO"),
     *                       @OA\Property(property="master_client_ID", type="string", example="ACBLO"),
     *                       @OA\Property(property="master_client_name", type="string", example="ARCADIA CARE BLOOMINGTON"),
     *                       @OA\Property(property="provider_id", type="string", example="177,245,538,566,648,660,725,694,8,1002,28,26,2141,702,60,27,22,29,2174,2184,143,2199,39,1534,2197,160,54,243,1517,1756,2136,135"),
     *                       @OA\Property(property="ownership_group", type="string", example="ARCD"),
     *                 ),
     *             ),
     *             @OA\Property(property="deleted", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                       @OA\Property(property="client_name", type="string", example="ARCADIA CARE BLOOMINGTON[ACBLO]"),
     *                       @OA\Property(property="client_email", type="string", nullable=true),
     *                       @OA\Property(property="client_phone", type="string", example="1-309-827-6046"),
     *                       @OA\Property(property="client_fax", type="string", nullable=true),
     *                       @OA\Property(property="client_website", type="string", nullable=true),
     *                       @OA\Property(property="client_type", type="string", nullable=true),
     *                       @OA\Property(property="client_street", type="string", example="1509 N CALHOUN STREET"),
     *                       @OA\Property(property="client_city", type="string", example="BLOOMINGTON"),
     *                       @OA\Property(property="client_state", type="string", example="IL"),
     *                       @OA\Property(property="client_zip", type="string", example="61701"),
     *                       @OA\Property(property="client_lab", type="string", nullable=true),
     *                       @OA\Property(property="client_lab_acct", type="string", nullable=true),
     *                       @OA\Property(property="client_signed_agreement", type="string", nullable=true),
     *                       @OA\Property(property="client_preferred_lab", type="string", nullable=true),
     *                       @OA\Property(property="client_warning", type="string", nullable=true),
     *                       @OA\Property(property="client_notes", type="string", nullable=true),
     *                       @OA\Property(property="status", type="integer", example=1),
     *                       @OA\Property(property="subscriber_id", type="integer", example=9),
     *                       @OA\Property(property="delete_status", type="integer", example=0),
     *                       @OA\Property(property="delete_by", type="integer", nullable=true),
     *                       @OA\Property(property="service_day", type="string", nullable=true),
     *                       @OA\Property(property="latitude", type="string", example="40.493323"),
     *                       @OA\Property(property="longitude", type="string", example="-89.005142"),
     *                       @OA\Property(property="sms_notification", type="integer", example=0),
     *                       @OA\Property(property="email_notification", type="integer", example=0),
     *                       @OA\Property(property="sms_notification_status", type="string", nullable=true),
     *                       @OA\Property(property="email_notification_status", type="string", nullable=true),
     *                       @OA\Property(property="lab_account_no", type="string", nullable=true),
     *                       @OA\Property(property="client_street2", type="string", example=""),
     *                       @OA\Property(property="clientID", type="string", example="ACBLO"),
     *                       @OA\Property(property="master_client_ID", type="string", example="ACBLO"),
     *                       @OA\Property(property="master_client_name", type="string", example="ARCADIA CARE BLOOMINGTON"),
     *                       @OA\Property(property="provider_id", type="string", example="177,245,538,566,648,660,725,694,8,1002,28,26,2141,702,60,27,22,29,2174,2184,143,2199,39,1534,2197,160,54,243,1517,1756,2136,135"),
     *                       @OA\Property(property="ownership_group", type="string", example="ARCD"),
     *                 ),
     *             ),
     *         ),
     *     ),
     * )
     */
    public function getList(Request $request){
        $currentTimeStamp = $request->timestamp ? Carbon::createFromTimestamp($request->timestamp)->format('Y-m-d') : null;
        $added = [];
        $updated = [];
        $deleted = [];
        if($currentTimeStamp){

            //client_street2 not found
            // clientID not found
            // master_client_ID not found
            // master_client_name not found
            // provider_id not found
            // ownership_group not found
            $added = Client::whereNull('deleted_at')->whereDate('created_at','>=',$currentTimeStamp)->get(["client_id",'client_name','client_email','client_phone','client_fax','client_website','client_type','client_street','client_city','client_state','client_zip','client_lab','client_lab_acct','client_signed_agreement','client_preferred_lab','client_warning','client_notes','status','subscriber_id','delete_by','service_day','latitude','longitude','sms_notification','email_notification','sms_notification_status','email_notification_status','lab_account_no']);
            $addedIDs = $added->pluck('client_id')->toArray();
            $updated = Client::whereNotIn('client_id',$addedIDs)->whereNull('deleted_at')->whereDate('updated_at','>=',$currentTimeStamp)->get(["client_id",'client_name','client_email','client_phone','client_fax','client_website','client_type','client_street','client_city','client_state','client_zip','client_lab','client_lab_acct','client_signed_agreement','client_preferred_lab','client_warning','client_notes','status','subscriber_id','delete_by','service_day','latitude','longitude','sms_notification','email_notification','sms_notification_status','email_notification_status','lab_account_no']);
            $deleted = Client::whereNotNull('deleted_at')->whereDate('updated_at','>=',$currentTimeStamp)->get(["client_id",'client_name','client_email','client_phone','client_fax','client_website','client_type','client_street','client_city','client_state','client_zip','client_lab','client_lab_acct','client_signed_agreement','client_preferred_lab','client_warning','client_notes','status','subscriber_id','delete_by','service_day','latitude','longitude','sms_notification','email_notification','sms_notification_status','email_notification_status','lab_account_no']);
        }else{
            $added = Client::whereNull('deleted_at')->get(["client_id",'client_name','client_email','client_phone','client_fax','client_website','client_type','client_street','client_city','client_state','client_zip','client_lab','client_lab_acct','client_signed_agreement','client_preferred_lab','client_warning','client_notes','status','subscriber_id','delete_by','service_day','latitude','longitude','sms_notification','email_notification','sms_notification_status','email_notification_status','lab_account_no']);
            $deleted = Client::whereNotNull('deleted_at')->get(["client_id",'client_name','client_email','client_phone','client_fax','client_website','client_type','client_street','client_city','client_state','client_zip','client_lab','client_lab_acct','client_signed_agreement','client_preferred_lab','client_warning','client_notes','status','subscriber_id','delete_by','service_day','latitude','longitude','sms_notification','email_notification','sms_notification_status','email_notification_status','lab_account_no']);
        }
        return ['success'=>true,"added"=>$added, "updated"=>$updated, "deleted"=>$deleted];
    }
}
