<?php

namespace App\Http\Controllers;

use App\Models\Ethnicity;
use Carbon\Carbon;
use Illuminate\Http\Request;

class EthnicityController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth:api');
    }
    /**
     * @OA\Post(
     *     path="/api/ethnicity/getlist",
     *     operationId="ethnicitygetList",
     *     tags={"Protected Routes"},
     *     summary="Get List of Ethnicities",
     *     description="This route requires authentication. Retrieves a list of Ethnicities with details on added, updated, and deleted items.",
     *     security={{"bearerAuth": {}}},
     *     @OA\RequestBody(
     *         required=true,
     *         description="User credentials",
     *         @OA\JsonContent(
     *             @OA\Property(property="timestamp", type="string", format="timestamp", example=1828384884)
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful response",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="success", type="boolean", example=true),
     *             @OA\Property(property="added", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="id", type="integer", example=1),
     *                     @OA\Property(property="name", type="string"),
     *                 ),
     *             ),
     *             @OA\Property(property="updated", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="id", type="integer", example=1),
     *                     @OA\Property(property="name", type="string"),
     *                 ),
     *             ),
     *             @OA\Property(property="deleted", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="id", type="integer", example=1),
     *                     @OA\Property(property="name", type="string"),
     *                 ),
     *             ),
     *         ),
     *     ),
     * )
     */
    public function getList(Request $request){
        $currentTimeStamp = $request->timestamp ? Carbon::createFromTimestamp($request->timestamp)->format('Y-m-d') : null;
        $added = [];
        $updated = [];
        $deleted = [];
        if($currentTimeStamp){
            $added = Ethnicity::whereDate('created_at','>=',$currentTimeStamp)->get(["id","name"]);
            $addedIDs = $added->pluck('id')->toArray();
            $updated = Ethnicity::whereNotIn('id',$addedIDs)->whereDate('updated_at','>=',$currentTimeStamp)->get(["id","name"]);
            $deleted = [];
        }else{
            $added = Ethnicity::get(["id","name"]);
            $deleted = Ethnicity::get(["id","name"]);
        }
        return ['success'=>true,"added"=>$added, "updated"=>$updated, "deleted"=>$deleted];
    }
}
