<?php

namespace App\Http\Controllers;

use App\Models\Insurance;
use Carbon\Carbon;
use Illuminate\Http\Request;

class InsuranceController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:api');
    }
    /**
     * @OA\Post(
     *     path="/api/insurance/getlist",
     *     operationId="insuranceList",
     *     tags={"Protected Routes"},
     *     summary="Get List of insurance",
     *     description="This route requires authentication. Retrieves a list of insurance with details on added, updated, and deleted items.",
     *     security={{"bearerAuth": {}}},
     *     @OA\RequestBody(
     *         required=true,
     *         description="User credentials",
     *         @OA\JsonContent(
     *             @OA\Property(property="timestamp", type="string", format="timestamp", example=1828384884)
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful response",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="success", type="boolean", example=true),
     *             @OA\Property(property="added", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="insurance_name", type="string", example="Blue Shield of CA"),
     *                     @OA\Property(property="insurance_email", type="string", example="blueshield@phlebio.com"),
     *                     @OA\Property(property="insurance_phone", type="string", example="1231231231"),
     *                     @OA\Property(property="insurance_fax", type="string", example="1231231"),
     *                     @OA\Property(property="insurance_website", type="string", example="www.phlebio.com"),
     *                     @OA\Property(property="insurance_street", type="string", example="5523 Blueshield Way"),
     *                     @OA\Property(property="insurance_city", type="string", example="Monrovia"),
     *                     @OA\Property(property="insurance_state", type="string", example="California"),
     *                     @OA\Property(property="insurance_zip", type="string", example="91016"),
     *                     @OA\Property(property="insurance_warning", type="string", nullable=true),
     *                     @OA\Property(property="insurance_notes", type="string", example="test"),
     *                     @OA\Property(property="status", type="integer", example=1),
     *                     @OA\Property(property="insurance_type", type="integer", example=0),
     *                 ),
     *             ),
     *             @OA\Property(property="updated", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="insurance_name", type="string", example="Blue Shield of CA"),
     *                     @OA\Property(property="insurance_email", type="string", example="blueshield@phlebio.com"),
     *                     @OA\Property(property="insurance_phone", type="string", example="1231231231"),
     *                     @OA\Property(property="insurance_fax", type="string", example="1231231"),
     *                     @OA\Property(property="insurance_website", type="string", example="www.phlebio.com"),
     *                     @OA\Property(property="insurance_street", type="string", example="5523 Blueshield Way"),
     *                     @OA\Property(property="insurance_city", type="string", example="Monrovia"),
     *                     @OA\Property(property="insurance_state", type="string", example="California"),
     *                     @OA\Property(property="insurance_zip", type="string", example="91016"),
     *                     @OA\Property(property="insurance_warning", type="string", nullable=true),
     *                     @OA\Property(property="insurance_notes", type="string", example="test"),
     *                     @OA\Property(property="status", type="integer", example=1),
     *                     @OA\Property(property="insurance_type", type="integer", example=0),
     *                 ),
     *             ),
     *             @OA\Property(property="deleted", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="insurance_name", type="string", example="Blue Shield of CA"),
     *                     @OA\Property(property="insurance_email", type="string", example="blueshield@phlebio.com"),
     *                     @OA\Property(property="insurance_phone", type="string", example="1231231231"),
     *                     @OA\Property(property="insurance_fax", type="string", example="1231231"),
     *                     @OA\Property(property="insurance_website", type="string", example="www.phlebio.com"),
     *                     @OA\Property(property="insurance_street", type="string", example="5523 Blueshield Way"),
     *                     @OA\Property(property="insurance_city", type="string", example="Monrovia"),
     *                     @OA\Property(property="insurance_state", type="string", example="California"),
     *                     @OA\Property(property="insurance_zip", type="string", example="91016"),
     *                     @OA\Property(property="insurance_warning", type="string", nullable=true),
     *                     @OA\Property(property="insurance_notes", type="string", example="test"),
     *                     @OA\Property(property="status", type="integer", example=1),
     *                     @OA\Property(property="insurance_type", type="integer", example=0),
     *                 ),
     *             ),
     *         ),
     *     ),
     * )
     */
    public function getList(Request $request){
        $currentTimeStamp = $request->timestamp ? Carbon::createFromTimestamp($request->timestamp)->format('Y-m-d') : null;
        $added = [];
        $updated = [];
        $deleted = [];
        if($currentTimeStamp){
            $added = Insurance::whereNull('deleted_at')->whereDate('created_at','>=',$currentTimeStamp)->get(['insurance_id','insurance_name','insurance_email','insurance_phone','insurance_fax','insurance_website','insurance_street','insurance_city','insurance_state','insurance_zip','insurance_warning','insurance_notes','status','insurance_type']);
            $addedIDs = $added->pluck('insurance_id')->toArray();
            $updated = Insurance::whereNotIn('id',$addedIDs)->whereNull('deleted_at')->whereDate('updated_at','>=',$currentTimeStamp)->get(['insurance_id','insurance_name','insurance_email','insurance_phone','insurance_fax','insurance_website','insurance_street','insurance_city','insurance_state','insurance_zip','insurance_warning','insurance_notes','status','insurance_type']);
            $deleted = Insurance::whereNotNull('deleted_at')->whereDate('updated_at','>=',$currentTimeStamp)->get('insurance_id',['insurance_name','insurance_email','insurance_phone','insurance_fax','insurance_website','insurance_street','insurance_city','insurance_state','insurance_zip','insurance_warning','insurance_notes','status','insurance_type']);
        }else{
            $added = Insurance::whereNull('deleted_at')->get(['insurance_id','insurance_name','insurance_email','insurance_phone','insurance_fax','insurance_website','insurance_street','insurance_city','insurance_state','insurance_zip','insurance_warning','insurance_notes','status','insurance_type']);
            $deleted = Insurance::whereNotNull('deleted_at')->get(['insurance_id','insurance_name','insurance_email','insurance_phone','insurance_fax','insurance_website','insurance_street','insurance_city','insurance_state','insurance_zip','insurance_warning','insurance_notes','status','insurance_type']);
        }
        return ['success'=>true,"added"=>$added, "updated"=>$updated, "deleted"=>$deleted];
    }
}
