<?php

namespace App\Http\Controllers;

use App\Models\Labtest;
use Carbon\Carbon;
use Illuminate\Http\Request;

class LabtestController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:api');
    }
    /**
     * @OA\Post(
     *     path="/api/labtest/getlist",
     *     operationId="labtestgetList",
     *     tags={"Protected Routes"},
     *     summary="Get List of labtest",
     *     description="This route requires authentication. Retrieves a list of labtest with details on added, updated, and deleted items.",
     *     security={{"bearerAuth": {}}},
     *     @OA\RequestBody(
     *         required=true,
     *         description="User credentials",
     *         @OA\JsonContent(
     *             @OA\Property(property="timestamp", type="string", format="timestamp", example=1828384884)
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful response",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="success", type="boolean", example=true),
     *             @OA\Property(property="added", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="laboratory_id", type="integer", example=1),
     *                     @OA\Property(property="lab_name", type="string", example="LIFESCAN"),
     *                     @OA\Property(property="test_tube_required", type="string", example="1,43"),
     *                     @OA\Property(property="test_type", type="string", example="HEMO"),
     *                     @OA\Property(property="test_code", type="string", example="CBC"),
     *                     @OA\Property(property="test_name", type="string", example="CBC WITH DIFF"),
     *                     @OA\Property(property="test_warning", type="string", nullable=true),
     *                     @OA\Property(property="test_is_poc", type="integer", example=0),
     *                     @OA\Property(property="test_is_fasting", type="integer", example=0),
     *                     @OA\Property(property="pt_inr_poc", type="integer", example=0),
     *                     @OA\Property(property="test_details", type="string", nullable=true),
     *                     @OA\Property(property="test_notes", type="string", nullable=true),
     *                     @OA\Property(property="status", type="integer", example=1),
     *                     @OA\Property(property="subscriber_id", type="integer", nullable=true),
     *                     @OA\Property(property="delete_by", type="integer", nullable=true),
     *                     @OA\Property(property="fasting", type="integer", example=0),
     *                     @OA\Property(property="timed_draw", type="integer", example=0),
     *                     @OA\Property(property="testtube_value", type="string", example="1,1"),
     *                     @OA\Property(property="combinable", type="integer", example=1),
     *                     @OA\Property(property="is_covid_test", type="integer", example=0),
     *                     @OA\Property(property="stat_lab_eligible", type="integer", example=0),
     *                     @OA\Property(property="is_pickup_only", type="integer", example=0),
     *                     @OA\Property(property="created_at", type="string", example="2022-03-18T05:50:14.000000Z"),
     *                     @OA\Property(property="updated_at", type="string", example="2023-11-20T12:45:15.000000Z"),
     *                     @OA\Property(property="deleted_at", type="string", nullable=true),
     *                     @OA\Property(property="delete_status", type="integer", example=0),
     *                 ),
     *             ),
     *             @OA\Property(property="updated", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="laboratory_id", type="integer", example=1),
     *                     @OA\Property(property="lab_name", type="string", example="LIFESCAN"),
     *                     @OA\Property(property="test_tube_required", type="string", example="1,43"),
     *                     @OA\Property(property="test_type", type="string", example="HEMO"),
     *                     @OA\Property(property="test_code", type="string", example="CBC"),
     *                     @OA\Property(property="test_name", type="string", example="CBC WITH DIFF"),
     *                     @OA\Property(property="test_warning", type="string", nullable=true),
     *                     @OA\Property(property="test_is_poc", type="integer", example=0),
     *                     @OA\Property(property="test_is_fasting", type="integer", example=0),
     *                     @OA\Property(property="pt_inr_poc", type="integer", example=0),
     *                     @OA\Property(property="test_details", type="string", nullable=true),
     *                     @OA\Property(property="test_notes", type="string", nullable=true),
     *                     @OA\Property(property="status", type="integer", example=1),
     *                     @OA\Property(property="subscriber_id", type="integer", nullable=true),
     *                     @OA\Property(property="delete_by", type="integer", nullable=true),
     *                     @OA\Property(property="fasting", type="integer", example=0),
     *                     @OA\Property(property="timed_draw", type="integer", example=0),
     *                     @OA\Property(property="testtube_value", type="string", example="1,1"),
     *                     @OA\Property(property="combinable", type="integer", example=1),
     *                     @OA\Property(property="is_covid_test", type="integer", example=0),
     *                     @OA\Property(property="stat_lab_eligible", type="integer", example=0),
     *                     @OA\Property(property="is_pickup_only", type="integer", example=0),
     *                     @OA\Property(property="created_at", type="string", example="2022-03-18T05:50:14.000000Z"),
     *                     @OA\Property(property="updated_at", type="string", example="2023-11-20T12:45:15.000000Z"),
     *                     @OA\Property(property="deleted_at", type="string", nullable=true),
     *                     @OA\Property(property="delete_status", type="integer", example=0),
     *                 ),
     *             ),
     *             @OA\Property(property="deleted", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="laboratory_id", type="integer", example=1),
     *                     @OA\Property(property="lab_name", type="string", example="LIFESCAN"),
     *                     @OA\Property(property="test_tube_required", type="string", example="1,43"),
     *                     @OA\Property(property="test_type", type="string", example="HEMO"),
     *                     @OA\Property(property="test_code", type="string", example="CBC"),
     *                     @OA\Property(property="test_name", type="string", example="CBC WITH DIFF"),
     *                     @OA\Property(property="test_warning", type="string", nullable=true),
     *                     @OA\Property(property="test_is_poc", type="integer", example=0),
     *                     @OA\Property(property="test_is_fasting", type="integer", example=0),
     *                     @OA\Property(property="pt_inr_poc", type="integer", example=0),
     *                     @OA\Property(property="test_details", type="string", nullable=true),
     *                     @OA\Property(property="test_notes", type="string", nullable=true),
     *                     @OA\Property(property="status", type="integer", example=1),
     *                     @OA\Property(property="subscriber_id", type="integer", nullable=true),
     *                     @OA\Property(property="delete_by", type="integer", nullable=true),
     *                     @OA\Property(property="fasting", type="integer", example=0),
     *                     @OA\Property(property="timed_draw", type="integer", example=0),
     *                     @OA\Property(property="testtube_value", type="string", example="1,1"),
     *                     @OA\Property(property="combinable", type="integer", example=1),
     *                     @OA\Property(property="is_covid_test", type="integer", example=0),
     *                     @OA\Property(property="stat_lab_eligible", type="integer", example=0),
     *                     @OA\Property(property="is_pickup_only", type="integer", example=0),
     *                     @OA\Property(property="created_at", type="string", example="2022-03-18T05:50:14.000000Z"),
     *                     @OA\Property(property="updated_at", type="string", example="2023-11-20T12:45:15.000000Z"),
     *                     @OA\Property(property="deleted_at", type="string", nullable=true),
     *                     @OA\Property(property="delete_status", type="integer", example=0),
     *                 ),
     *             ),
     *         ),
     *     ),
     * )
     */
    public function getList(Request $request){
        $currentTimeStamp = $request->timestamp ? Carbon::createFromTimestamp($request->timestamp)->format('Y-m-d') : null;
        $added = [];
        $updated = [];
        $deleted = [];
        if($currentTimeStamp){
            // labtest.timed_draw not found
            // labtest.combinable not found
            // labtest.is_covid_test not found
            // labtest.stat_lab_eligible not found
            // labtest.is_pickup_only not found
            // whereNull('deleted_at')
            // whereNotNull('deleted_at')
            $added = Labtest::leftJoin('laboratories','laboratories.laboratory_id','=','labtest.test_processing_lab')->whereNull('labtest.deleted_at')->whereDate('labtest.created_at','>=',$currentTimeStamp)->get(['labtest.labtest_id','laboratories.laboratory_id','laboratories.lab_name','labtest.test_tube_required','labtest.test_type','labtest.test_code','labtest.test_name','labtest.test_warning','labtest.test_is_poc','labtest.test_is_fasting','labtest.pt_inr_poc','labtest.test_details','labtest.test_notes','labtest.status','labtest.subscriber_id','labtest.delete_by','labtest.fasting','labtest.testtube_value','labtest.created_at','labtest.updated_at','labtest.deleted_at']);

            $addedIDs = $added->pluck('labtest.labtest_id')->toArray();
            $updated = Labtest::leftJoin('laboratories','laboratories.laboratory_id','=','labtest.test_processing_lab')->whereNotIn('labtest.labtest_id',$addedIDs)->whereNull('labtest.deleted_at')->whereDate('labtest.updated_at','>=',$currentTimeStamp)->get(['labtest.labtest_id','laboratories.laboratory_id','laboratories.lab_name','labtest.test_tube_required','labtest.test_type','labtest.test_code','labtest.test_name','labtest.test_warning','labtest.test_is_poc','labtest.test_is_fasting','labtest.pt_inr_poc','labtest.test_details','labtest.test_notes','labtest.status','labtest.subscriber_id','labtest.delete_by','labtest.fasting','labtest.testtube_value','labtest.created_at','labtest.updated_at','labtest.deleted_at']);
            $deleted = Labtest::leftJoin('laboratories','laboratories.laboratory_id','=','labtest.test_processing_lab')->whereNotNull('labtest.deleted_at')->whereDate('labtest.updated_at','>=',$currentTimeStamp)->get(['labtest.labtest_id','laboratories.laboratory_id','laboratories.lab_name','labtest.test_tube_required','labtest.test_type','labtest.test_code','labtest.test_name','labtest.test_warning','labtest.test_is_poc','labtest.test_is_fasting','labtest.pt_inr_poc','labtest.test_details','labtest.test_notes','labtest.status','labtest.subscriber_id','labtest.delete_by','labtest.fasting','labtest.testtube_value','labtest.created_at','labtest.updated_at','labtest.deleted_at']);
        }else{
            $added = Labtest::leftJoin('laboratories','laboratories.laboratory_id','=','labtest.test_processing_lab')->whereNull('labtest.deleted_at')->get(['labtest.labtest_id','laboratories.laboratory_id','laboratories.lab_name','labtest.test_tube_required','labtest.test_type','labtest.test_code','labtest.test_name','labtest.test_warning','labtest.test_is_poc','labtest.test_is_fasting','labtest.pt_inr_poc','labtest.test_details','labtest.test_notes','labtest.status','labtest.subscriber_id','labtest.delete_by','labtest.fasting','labtest.testtube_value','labtest.created_at','labtest.updated_at','labtest.deleted_at']);
            $deleted = Labtest::leftJoin('laboratories','laboratories.laboratory_id','=','labtest.test_processing_lab')->whereNotNull('labtest.deleted_at')->get(['labtest.labtest_id','laboratories.laboratory_id','laboratories.lab_name','labtest.test_tube_required','labtest.test_type','labtest.test_code','labtest.test_name','labtest.test_warning','labtest.test_is_poc','labtest.test_is_fasting','labtest.pt_inr_poc','labtest.test_details','labtest.test_notes','labtest.status','labtest.subscriber_id','labtest.delete_by','labtest.fasting','labtest.testtube_value','labtest.created_at','labtest.updated_at','labtest.deleted_at']);
        }
        return response()->json(['success'=>true,"added"=>$added, "updated"=>$updated, "deleted"=>$deleted],200);
    }
}
